function [MK, GK] = Kurvature(r,h,Nodes)
%Calculate mean curvature for diffusion tube
%   Using the local coordinates we've always employed tabulate the mean
%   curvature at all nodal values so we may use it as a parameter in the
%   diffusion coefficient.

%Per page 83 of Struik, mean curvature may found by the expression
%MK = 1/2(Eg-2fF+eG)/(EG-F^2)
%where the first fund form I = [[E F];[F G]] and second II = [[e f];[f g]]

%First fundamental form coeffs:
E = arrayfun(@(x,y) 16*r^2/(1+4*x.^2+y.^2).^2 * (sqrt(x.^2+y.^2)<=.5) + 1/(x.^2+y.^2)*(r^2.*y.^4/(x.^2+y.^2).^2+r^2*x.^2.*y.^2/(x.^2+y.^2).^2+4*h^2.*x.^2).*(sqrt(x.^2+y.^2)>.5),Nodes(:,1),Nodes(:,2));
F = arrayfun(@(x,y) 1/(x.^2+y.^2)*(r^2*-x.*y.^3/(x.^2+y.^2).^2+r^2*-x.^3.*y/(x.^2+y.^2).^2 +4*h^2*x.*y)*(sqrt(x.^2+y.^2)>.5),Nodes(:,1),Nodes(:,2));
G = arrayfun(@(x,y) 16*r^2/(1+4*x.^2+4*y.^2).^2 * (sqrt(x.^2+y.^2)<=.5) + 1/(x.^2+y.^2)*(r^2*x.^2.*y.^2/(x.^2+y.^2).^2+r^2.*x.^4/(x.^2+y.^2).^2+4*h^2.*y.^2).*(sqrt(x.^2+y.^2)>.5),Nodes(:,1),Nodes(:,2));

%Second fundamental form coeffs:
e = arrayfun(@(x,y) 16*r/(1+4.*x.^2+4.*y.^2).^2*(sqrt(x.^2+y.^2)<=.5)+1/(x.^2+y.^2).^4.*((3.*y.^2+x.^2).*(r*x.^2.*y.^2 - r.*(2*y.^2-x.^2).*x.^2)+2*r*x.^4.*y.^2/(x.^2+y.^2).^4+2*r*(2*y.^2-x.^2).*x.^2/(x.^2+y.^2).^4)*(sqrt(x.^2+y.^2)>.5),Nodes(:,1),Nodes(:,2));
f = arrayfun(@(x,y) r*((x.^2-y.^2).*(-x.*y.^3/(x.^2+y.^2).^4 - x.*y.*(x.^2-2*y.^2)/(x.^2+y.^2).^4) - 2*x.^5.*y/(x.^2+y.^2).^4+2*x.^3.*(x.^2-2*y.^2).*y/(x.^2+y.^2).^4)*(sqrt(x.^2+y.^2)>.5),Nodes(:,1),Nodes(:,2));
g = arrayfun(@(x,y) 16*r/(1+4.*x.^2+4.*y.^2).^2*(sqrt(x.^2+y.^2)<=.5)+( (3*y.^2+x.^2)*( r*x.^2.*y.^2/(x.^2+y.^2).^4 -(2*y.^2-x.^2).*r.*x.^2/(x.^2+y.^2).^4 ) + 2*h*r*x.^4.*y.^2/(x.^2+y.^2).^4 + 2.*y.^2.*(2*y.^2-x.^2)*r.*x.^2/(x.^2+y.^2).^4 ).*(sqrt(x.^2+y.^2)>.5), Nodes(:,1),Nodes(:,2));

%Find where won't be defined cause of syntax fault and manually define
i = 1;
while Nodes(i,1) ~= 0 || Nodes(i,2) ~= 0
i = i+1;
end

E(i,1) = 16*r^2;
F(i,1) = 0;
G(i,1) = 16*r.^2;

e(i,1) = 16*r;
f(i,1) = 0;
g(i,1) = 16*r;

%Calculate Mean Curvature at Nodals
MK = .5*(E.*g-2*f.*F+e.*G)./(E.*G-F.^2);
GK = (e.*g - f.^2)./(E.*G - F.^2);
end

